<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sales_return_types extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('sales_return_types_model','sales_return_types');
	}

	public function add(){
		$this->permission_check('sales_return_types_add');
		$data=$this->data;
		$data['page_title']='Sales Return Types';
		$this->load->view('sales_return_type', $data);
	}
	
	public function new_sales_return_type(){
		$this->form_validation->set_rules('sales_return_type_name', 'Sales Return Type Name', 'trim|required');
		$this->form_validation->set_rules('sales_return_type_initial', 'Sales Return Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result=$this->sales_return_types->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Sales Return Type Name and Initial.";
		}
	}
	
	public function update($id){
		$this->belong_to('db_sales_return_types',$id);
		$this->permission_check('sales_return_types_edit');
		$data=$this->data;
		$result=$this->sales_return_types->get_details($id,$data);
		$data=array_merge($data,$result);
		$data['page_title']='Sales Return Types';
		$this->load->view('sales_return_type', $data);
	}
	
	public function update_sales_return_type(){
		$this->form_validation->set_rules('sales_return_type_name', 'Sales Return Type Name', 'trim|required');
		$this->form_validation->set_rules('sales_return_type_initial', 'Sales Return Type Initial', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result=$this->sales_return_types->update_sales_return_type();
			echo $result;
		} else {
			echo "Please Enter Sales Return Type name and Initial.";
		}
	}
	
	public function index(){
		$this->permission_check('sales_return_types_view');
		$data=$this->data;
		$data['page_title']='Sales Return Types List';
		$this->load->view('sales-return-types-list', $data);
	}

	public function ajax_list()
	{
		$list = $this->sales_return_types->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $sales_return_type) {
			$no++;
			$row = array();
			
			$row[] = $sales_return_type->sales_return_type_name;
			$row[] = $sales_return_type->sales_return_type_initial;
			$row[] = $sales_return_type->description;

			if($sales_return_type->status==1){ 
				$str= "<span onclick='update_status(".$sales_return_type->id.",0)' id='span_".$sales_return_type->id."'  class='label label-success' style='cursor:pointer'>Active </span>";
			} else{ 
				$str = "<span onclick='update_status(".$sales_return_type->id.",1)' id='span_".$sales_return_type->id."'  class='label label-danger' style='cursor:pointer'> Inactive </span>";
			}
			$row[] = $str;

			$str2 = '<div class="btn-group" title="View Account">
							<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
								Action <span class="caret"></span>
							</a>
							<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

							if($this->permissions('sales_return_types_edit'))
							$str2.='<li>
								<a title="Edit Record ?" href="'.base_url('sales_return_types/update/'.$sales_return_type->id).'">
									<i class="fa fa-fw fa-edit text-blue"></i>Edit
								</a>
							</li>';

							if($this->permissions('sales_return_types_delete'))
							$str2.='<li>
								<a style="cursor:pointer" title="Delete Record ?" onclick="delete_sales_return_type('.$sales_return_type->id.')">
									<i class="fa fa-fw fa-trash text-red"></i>Delete
								</a>
							</li>
							
						</ul>
					</div>';			
			$row[] = $str2;

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->sales_return_types->count_all(),
						"recordsFiltered" => $this->sales_return_types->count_filtered(),
						"data" => $data,
				);
		echo json_encode($output);
	}

	public function update_status(){
		$this->permission_check_with_msg('sales_return_types_edit');
		$id=$this->input->post('id');
		$status=$this->input->post('status');
		$result=$this->sales_return_types->update_status($id,$status);
		return $result;
	}
	
	public function delete_sales_return_type(){
		$this->permission_check_with_msg('sales_return_types_delete');
		$id=$this->input->post('q_id');
		$result=$this->sales_return_types->delete_sales_return_type($id);
		return $result;
	}
	
	// Modal support for quick add from other forms
	public function add_sales_return_type_modal(){
		$this->permission_check('sales_return_types_add');
		$this->form_validation->set_rules('sales_return_type_name', 'Sales Return Type Name', 'trim|required');
		$this->form_validation->set_rules('sales_return_type_initial', 'Sales Return Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result=$this->sales_return_types->verify_and_save();
			
			// Fetch latest sales return type details
			$res=array();
			$query=$this->db->select("id,sales_return_type_name,sales_return_type_initial")
					->where('store_id',get_current_store_id())
					->from('db_sales_return_types')
					->order_by('id','desc')
					->limit(1)->get();
			
			$res['id']=$query->row()->id;
			$res['text']=$query->row()->sales_return_type_name; // For select2
			$res['sales_return_type_name']=$query->row()->sales_return_type_name;
			$res['sales_return_type_initial']=$query->row()->sales_return_type_initial;
			$res['result']=$result;
			
			echo json_encode($res);
		} else {
			echo json_encode(array('result' => 'Please Fill Compulsory Fields.'));
		}
	}
}
