<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Purchase_return_types Controller
 * Auto-generated on August 5, 2025
 * Manages CRUD operations for Purchase Return Types
 */
class Purchase_return_types extends MY_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('purchase_return_types_model','purchase_return_types');
	}

	/**
	 * Display add form
	 */
	public function add(){
		$this->permission_check('purchase_return_types_add');
		$data = $this->data;
		$data['page_title'] = 'Purchase Return Types';
		$this->load->view('purchase_return_type', $data);
	}

	/**
	 * Process new record creation
	 */
	public function new_purchase_return_type(){
		$this->form_validation->set_rules('purchase_return_type_name', 'Purchase Return Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_return_type_initial', 'Purchase Return Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_return_types->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Purchase Return Type Name and Initial.";
		}
	}

	/**
	 * Display edit form
	 */
	public function update($id){
		$this->belong_to('db_purchase_return_types', $id);
		$this->permission_check('purchase_return_types_edit');
		$data = $this->data;
		$result = $this->purchase_return_types->get_details($id, $data);
		$data = array_merge($data, $result);
		$data['page_title'] = 'Purchase Return Types';
		$this->load->view('purchase_return_type', $data);
	}

	/**
	 * Process record update
	 */
	public function update_purchase_return_type(){
		$this->form_validation->set_rules('purchase_return_type_name', 'Purchase Return Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_return_type_initial', 'Purchase Return Type Initial', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_return_types->update_purchase_return_type();
			echo $result;
		} else {
			echo "Please Enter Purchase Return Type name and Initial.";
		}
	}

	/**
	 * Display list view
	 */
	public function index(){
		$this->permission_check('purchase_return_types_view');
		$data = $this->data;
		$data['page_title'] = 'Purchase Return Types List';
		$this->load->view('purchase-return-types-list', $data);
	}

	/**
	 * AJAX DataTables data source
	 */
	public function ajax_list(){
		$list = $this->purchase_return_types->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $purchase_return_type) {
			$no++;
			$row = array();
			
			// Main fields
			$row[] = $purchase_return_type->purchase_return_type_name;
			$row[] = $purchase_return_type->purchase_return_type_initial;
			$row[] = $purchase_return_type->description;

			// Status
			if($purchase_return_type->status == 1){ 
				$str = "<span onclick='update_status(".$purchase_return_type->id.",0)' id='span_".$purchase_return_type->id."' class='label label-success' style='cursor:pointer'>Active</span>";
			} else{ 
				$str = "<span onclick='update_status(".$purchase_return_type->id.",1)' id='span_".$purchase_return_type->id."' class='label label-danger' style='cursor:pointer'>Inactive</span>";
			}
			$row[] = $str;

			// Actions
			$actions = '<div class="btn-group" title="View Account">
							<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
								Action <span class="caret"></span>
							</a>
							<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

			if($this->permissions('purchase_return_types_edit'))
				$actions .= '<li><a title="Edit Record ?" href="'.base_url('purchase_return_types/update/'.$purchase_return_type->id).'">
								<i class="fa fa-fw fa-edit text-blue"></i>Edit
							</a></li>';

			if($this->permissions('purchase_return_types_delete'))
				$actions .= '<li><a style="cursor:pointer" title="Delete Record ?" onclick="delete_purchase_return_type('.$purchase_return_type->id.')">
								<i class="fa fa-fw fa-trash text-red"></i>Delete
							</a></li>';
							
			$actions .= '</ul></div>';
			$row[] = $actions;

			$data[] = $row;
		}

		$output = array(
			"draw" => $_POST['draw'],
			"recordsTotal" => $this->purchase_return_types->count_all(),
			"recordsFiltered" => $this->purchase_return_types->count_filtered(),
			"data" => $data,
		);
		echo json_encode($output);
	}

	/**
	 * Update record status
	 */
	public function update_status(){
		$this->permission_check_with_msg('purchase_return_types_edit');
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$result = $this->purchase_return_types->update_status($id, $status);
		return $result;
	}

	/**
	 * Delete record
	 */
	public function delete_purchase_return_type(){
		$this->permission_check_with_msg('purchase_return_types_delete');
		$id = $this->input->post('q_id');
		$result = $this->purchase_return_types->delete_purchase_return_type($id);
		return $result;
	}

	/**
	 * Modal support for quick add
	 */
	public function add_purchase_return_type_modal(){
		$this->form_validation->set_rules('purchase_return_type_name', 'Purchase Return Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_return_type_initial', 'Purchase Return Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_return_types->verify_and_save();
			
			// Return new record for dropdown population
			$query = $this->db->select("id, purchase_return_type_name, purchase_return_type_initial")
							->where('store_id', get_current_store_id())
							->from('db_purchase_return_types')
							->order_by('id', 'desc')
							->limit(1)->get();
			
			$res = array();
			$res['id'] = $query->row()->id;
			$res['purchase_return_type'] = $query->row()->purchase_return_type_name;
			$res['purchase_return_type_initial'] = $query->row()->purchase_return_type_initial;
			$res['result'] = $result;
			
			echo json_encode($res);
		} else {
			echo "Please Fill Compulsory(* marked) Fields.";
		}
	}
}
