<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Account_transactions extends MY_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load_global();
        $this->load->model('customers_model','customers');
        $this->load->model('sales_model','sales');
    }
    
    public function customer_history($customer_id = null) {
        // This method can be used for direct access via URL
        if(!$customer_id) {
            $customer_id = $this->input->get('customer_id');
        }
        
        if(!$customer_id) {
            show_error('Customer ID is required', 400);
            return;
        }
        
        // Check if customer exists
        $customer = $this->db->get_where('db_customers', array('id' => $customer_id))->row();
        if(!$customer) {
            show_error('Customer not found', 404);
            return;
        }
        
        // Load the view directly
        $this->load->view('customer_ledger_report');
    }
    
    public function add_transaction() {
        // Method to add manual transactions if needed
        $this->permission_check('accounts_add');
        
        $customer_id = $this->input->post('customer_id');
        $transaction_type = $this->input->post('transaction_type');
        $amount = $this->input->post('amount');
        $description = $this->input->post('description');
        $payment_mode = $this->input->post('payment_mode');
        $reference_number = $this->input->post('reference_number');
        $transaction_date = $this->input->post('transaction_date');
        
        $data = array(
            'customer_id' => $customer_id,
            'transaction_type' => $transaction_type,
            'amount' => $amount,
            'description' => $description,
            'payment_mode' => $payment_mode,
            'reference_number' => $reference_number,
            'transaction_date' => $transaction_date,
            'created_by' => $this->session->userdata('inv_userid'),
            'status' => 'Active'
        );
        
        if($this->db->insert('db_account_transactions', $data)) {
            // Update customer balance
            $this->update_customer_balance($customer_id);
            
            echo json_encode(array('status' => 'success', 'message' => 'Transaction added successfully'));
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Failed to add transaction'));
        }
    }
    
    private function update_customer_balance($customer_id) {
        // Calculate total debit and credit
        $this->db->select('SUM(CASE WHEN transaction_type = "DEBIT" THEN amount ELSE 0 END) as total_debit,
                          SUM(CASE WHEN transaction_type = "CREDIT" THEN amount ELSE 0 END) as total_credit');
        $this->db->where('customer_id', $customer_id);
        $this->db->where('status', 'Active');
        $result = $this->db->get('db_account_transactions')->row();
        
        $total_debit = $result->total_debit ?: 0;
        $total_credit = $result->total_credit ?: 0;
        
        // Get opening balance
        $customer = $this->db->get_where('db_customers', array('id' => $customer_id))->row();
        $opening_balance = $customer->opening_balance ?: 0;
        
        // Calculate current balance
        $current_balance = $opening_balance + $total_debit - $total_credit;
        
        // Update customer balance
        $this->db->where('id', $customer_id);
        $this->db->update('db_customers', array('sales_due' => $current_balance));
    }
}
