<?php
/**
 * Enhanced Database Connection and Feature Test
 * Tests database connectivity and core functionality of GST Notes module
 */

require_once 'config.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>GST Notes Module - Connection & Feature Test</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>
    <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css' rel='stylesheet'>
    <style>
        .test-success { color: #28a745; }
        .test-error { color: #dc3545; }
        .test-warning { color: #ffc107; }
        .test-info { color: #17a2b8; }
    </style>
</head>
<body class='bg-light'>
<div class='container mt-4'>
<h2><i class='fas fa-database me-2'></i>GST Notes Module - System Test</h2>
<p class='text-muted'>Testing database connectivity and core functionality...</p>
<hr>";
        $db_config['username'],
        $db_config['password'],
        $db_config['database']
    );

$tests = [];
$overall_status = true;

// Test 1: Database Connection
echo "<div class='card mb-3'>";
echo "<div class='card-header'><strong>Test 1: Database Connection</strong></div>";
echo "<div class='card-body'>";

try {
    if ($mysqli->connect_error) {
        throw new Exception("Connection failed: " . $mysqli->connect_error);
    }
    echo "<p class='test-success'><i class='fas fa-check-circle'></i> ✓ Database connection successful</p>";
    echo "<p class='test-info'><i class='fas fa-info-circle'></i> Connected to: " . $mysqli->get_server_info() . "</p>";
    echo "<p class='test-info'><i class='fas fa-database'></i> Character set: " . $mysqli->character_set_name() . "</p>";
    $tests['database'] = true;
} catch (Exception $e) {
    echo "<p class='test-error'><i class='fas fa-times-circle'></i> ✗ " . $e->getMessage() . "</p>";
    $tests['database'] = false;
    $overall_status = false;
}

echo "</div></div>";

// Test 2: Table Structure
echo "<div class='card mb-3'>";
echo "<div class='card-header'><strong>Test 2: Table Structure</strong></div>";
echo "<div class='card-body'>";

$required_tables = ['credit_notes', 'debit_notes'];
foreach ($required_tables as $table) {
    try {
        $result = $mysqli->query("DESCRIBE $table");
        if ($result) {
            echo "<p class='test-success'><i class='fas fa-check-circle'></i> ✓ Table '$table' exists with " . $result->num_rows . " columns</p>";
            $tests[$table] = true;
        } else {
            throw new Exception("Table '$table' not found");
        }
    } catch (Exception $e) {
        echo "<p class='test-error'><i class='fas fa-times-circle'></i> ✗ " . $e->getMessage() . "</p>";
        $tests[$table] = false;
        $overall_status = false;
    }
}

echo "</div></div>";

// Overall Status
echo "<div class='card mb-3'>";
echo "<div class='card-header'><strong>Overall System Status</strong></div>";
echo "<div class='card-body text-center'>";

if ($overall_status) {
    echo "<h3 class='test-success'><i class='fas fa-check-circle'></i> System Ready</h3>";
    echo "<p class='test-success'>All core components are working properly. The GST Notes module is ready to use.</p>";
    echo "<div class='mt-3'>";
    echo "<a href='index.php' class='btn btn-primary me-2'><i class='fas fa-play'></i> Launch Application</a>";
    echo "<a href='index.php?page=reports' class='btn btn-success'><i class='fas fa-chart-bar'></i> View Reports</a>";
    echo "</div>";
} else {
    echo "<h3 class='test-error'><i class='fas fa-times-circle'></i> Issues Found</h3>";
    echo "<p class='test-error'>Some components need attention. Please review the errors above.</p>";
    echo "<div class='mt-3'>";
    echo "<button class='btn btn-danger' onclick='location.reload()'><i class='fas fa-sync'></i> Retest System</button>";
    echo "</div>";
}

echo "</div></div>";
echo "</div>";
echo "</body></html>";

// Close database connection
if ($mysqli && !$mysqli->connect_error) {
    $mysqli->close();
}
?>
