<?php
// Test AJAX functionality for reports
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include the report functions
require_once __DIR__ . '/report_functions.php';

// Set content type to JSON
header('Content-Type: application/json');

// Mock database functions for testing
if (!function_exists('fetchAll')) {
    function fetchAll($sql, $params = []) {
        // Mock data for testing
        return [
            [
                'note_category' => 'credit',
                'note_type' => 'sales',
                'count' => 5,
                'taxable_amount' => 10000.00,
                'cgst_amount' => 900.00,
                'sgst_amount' => 900.00,
                'igst_amount' => 0.00,
                'total_amount' => 11800.00
            ],
            [
                'note_category' => 'debit',
                'note_type' => 'purchase',
                'count' => 3,
                'taxable_amount' => 5000.00,
                'cgst_amount' => 450.00,
                'sgst_amount' => 450.00,
                'igst_amount' => 0.00,
                'total_amount' => 5900.00
            ]
        ];
    }
}

// Test parameters
$test_params = [
    'report_type' => 'summary',
    'note_type' => 'both',
    'transaction_type' => 'both',
    'from_date' => '2024-01-01',
    'to_date' => '2024-01-31'
];

try {
    // Test the AJAX response
    if (isset($_GET['action']) && $_GET['action'] === 'generate_report') {
        $data = getReportData($test_params);
        
        $response = [
            'status' => 'success',
            'data' => $data,
            'message' => 'Report generated successfully'
        ];
        
        echo json_encode($response, JSON_PRETTY_PRINT);
    } else {
        // Test page
        echo json_encode([
            'status' => 'info',
            'message' => 'AJAX Test Page - Add ?action=generate_report to test AJAX functionality',
            'functions_available' => [
                'getReportData' => function_exists('getReportData'),
                'getSummaryReport' => function_exists('getSummaryReport'),
                'getDetailedReport' => function_exists('getDetailedReport'),
                'exportToCSV' => function_exists('exportToCSV')
            ]
        ], JSON_PRETTY_PRINT);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Error: ' . $e->getMessage(),
        'line' => $e->getLine(),
        'file' => $e->getFile()
    ], JSON_PRETTY_PRINT);
}
?>
