-- GST Credit & Debit Notes Database Schema
-- Run this SQL on the billing_pos database to create the required tables

USE `billing_pos`;

-- Table for Credit Notes
CREATE TABLE `credit_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `note_number` varchar(50) NOT NULL UNIQUE,
  `note_date` date NOT NULL,
  `note_type` enum('sales','purchase') NOT NULL DEFAULT 'sales',
  `party_name` varchar(255) NOT NULL,
  `party_gstin` varchar(15) DEFAULT NULL,
  `party_address` text DEFAULT NULL,
  `original_invoice_no` varchar(50) NOT NULL,
  `original_invoice_date` date NOT NULL,
  `reason` text NOT NULL,
  `taxable_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `cgst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `cgst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `sgst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `sgst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `igst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `igst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_note_type` (`note_type`),
  KEY `idx_party_name` (`party_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table for Debit Notes
CREATE TABLE `debit_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `note_number` varchar(50) NOT NULL UNIQUE,
  `note_date` date NOT NULL,
  `note_type` enum('sales','purchase') NOT NULL DEFAULT 'sales',
  `party_name` varchar(255) NOT NULL,
  `party_gstin` varchar(15) DEFAULT NULL,
  `party_address` text DEFAULT NULL,
  `original_invoice_no` varchar(50) NOT NULL,
  `original_invoice_date` date NOT NULL,
  `reason` text NOT NULL,
  `taxable_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `cgst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `cgst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `sgst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `sgst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `igst_rate` decimal(5,2) NOT NULL DEFAULT 0.00,
  `igst_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_note_type_debit` (`note_type`),
  KEY `idx_party_name_debit` (`party_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert some sample data
INSERT INTO `credit_notes` (`note_number`, `note_date`, `note_type`, `party_name`, `party_gstin`, `party_address`, `original_invoice_no`, `original_invoice_date`, `reason`, `taxable_amount`, `cgst_rate`, `cgst_amount`, `sgst_rate`, `sgst_amount`, `igst_rate`, `igst_amount`, `total_amount`) VALUES
('CN-2025-001', '2025-08-15', 'sales', 'ABC Traders', '27AABCT1332L1ZU', 'Mumbai, Maharashtra', 'INV-2025-100', '2025-08-10', 'Goods returned due to quality issue', 10000.00, 9.00, 900.00, 9.00, 900.00, 0.00, 0.00, 11800.00),
('CN-2025-002', '2025-08-14', 'purchase', 'XYZ Suppliers', '29AAPFX1234Q1Z5', 'Karnataka', 'PINV-2025-200', '2025-08-05', 'Price difference adjustment', 5000.00, 0.00, 0.00, 0.00, 0.00, 18.00, 900.00, 5900.00);

INSERT INTO `debit_notes` (`note_number`, `note_date`, `note_type`, `party_name`, `party_gstin`, `party_address`, `original_invoice_no`, `original_invoice_date`, `reason`, `taxable_amount`, `cgst_rate`, `cgst_amount`, `sgst_rate`, `sgst_amount`, `igst_rate`, `igst_amount`, `total_amount`) VALUES
('DN-2025-001', '2025-08-15', 'sales', 'PQR Industries', '33AABCP1234L1ZX', 'Tamil Nadu', 'INV-2025-150', '2025-08-08', 'Additional charges for express delivery', 2000.00, 9.00, 180.00, 9.00, 180.00, 0.00, 0.00, 2360.00),
('DN-2025-002', '2025-08-13', 'purchase', 'LMN Corporation', '19AAPFL1234Q1Z9', 'West Bengal', 'PINV-2025-250', '2025-08-01', 'Interest on delayed payment', 1500.00, 0.00, 0.00, 0.00, 0.00, 18.00, 270.00, 1770.00);
