<?php
/**
 * Database Configuration for GST Notes Module
 * Uses the main project's database configuration
 */

// Use main project's database settings (extracted from database.php)
// Since we can't directly include CodeIgniter's database.php due to BASEPATH check,
// we'll use the same configuration values
$db_config = [
    'host' => $_ENV['DB_HOST'] ?? 'localhost',
    'username' => $_ENV['DB_USER'] ?? 'root',
    'password' => $_ENV['DB_PASS'] ?? '',
    'database' => $_ENV['DB_NAME'] ?? 'billing_pos',
    'charset' => 'utf8mb4'
];

// Create MySQLi connection using main project settings
$mysqli = new mysqli(
    $db_config['host'],
    $db_config['username'],
    $db_config['password'],
    $db_config['database']
);

// Check connection
if ($mysqli->connect_error) {
    die('Connection failed: ' . $mysqli->connect_error);
}

// Set charset
$mysqli->set_charset($db_config['charset']);

// Global functions for common operations
function executeQuery($query, $params = []) {
    global $mysqli;
    
    $stmt = $mysqli->prepare($query);
    
    if ($params) {
        $types = str_repeat('s', count($params)); // assuming all strings for simplicity
        $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    return $stmt;
}

function fetchAll($query, $params = []) {
    $stmt = executeQuery($query, $params);
    $result = $stmt->get_result();
    return $result->fetch_all(MYSQLI_ASSOC);
}

function fetchOne($query, $params = []) {
    $stmt = executeQuery($query, $params);
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}

function getLastInsertId() {
    global $mysqli;
    return $mysqli->insert_id;
}

// Generate next note number
function generateNoteNumber($type) {
    $prefix = ($type === 'credit') ? 'CN' : 'DN';
    $year = date('Y');
    
    $table = $type . '_notes';
    $query = "SELECT MAX(CAST(SUBSTRING(note_number, -3) AS UNSIGNED)) as max_num 
              FROM $table 
              WHERE note_number LIKE '$prefix-$year-%'";
    
    $result = fetchOne($query);
    $next_num = ($result['max_num'] ?? 0) + 1;
    
    return $prefix . '-' . $year . '-' . str_pad($next_num, 3, '0', STR_PAD_LEFT);
}

// Calculate GST amounts
function calculateGST($taxable_amount, $cgst_rate = 0, $sgst_rate = 0, $igst_rate = 0) {
    $cgst_amount = ($taxable_amount * $cgst_rate) / 100;
    $sgst_amount = ($taxable_amount * $sgst_rate) / 100;
    $igst_amount = ($taxable_amount * $igst_rate) / 100;
    $total_amount = $taxable_amount + $cgst_amount + $sgst_amount + $igst_amount;
    
    return [
        'cgst_amount' => round($cgst_amount, 2),
        'sgst_amount' => round($sgst_amount, 2),
        'igst_amount' => round($igst_amount, 2),
        'total_amount' => round($total_amount, 2)
    ];
}
?>
