# GST Credit & Debit Notes Management System

A simple, compact PHP module for managing GST Credit and Debit notes for both Sales and Purchase transactions. No login required - just pure CRUD functionality with a clean sidebar interface.

## Features

- **Dashboard** - Overview with statistics and recent notes
- **Credit Notes Management** - Full CRUD operations for sales and purchase credit notes
- **Debit Notes Management** - Full CRUD operations for sales and purchase debit notes
- **GST Calculation** - Automatic calculation of CGST, SGST, and IGST amounts
- **Search Functionality** - Search notes by number, party name, or invoice number
- **Responsive Design** - Works on desktop and mobile devices
- **Clean UI** - Bootstrap-based modern interface with sidebar navigation

## Database Structure

### Tables Created:
- `credit_notes` - Stores all credit note records
- `debit_notes` - Stores all debit note records

### Fields for Each Table:
- Note details (number, date, type)
- Party information (name, GSTIN, address)
- Original invoice reference
- GST breakdown (rates and amounts)
- Timestamps (created, updated)

## Installation Instructions

### 1. Database Setup

1. Create a new MySQL database named `gst_notes`
2. Import the database structure:
   ```sql
   mysql -u root -p gst_notes < database.sql
   ```
   Or manually run the SQL commands from `database.sql`

### 2. Configuration

1. Update database credentials in `config.php` if needed:
   ```php
   $db_config = [
       'host' => 'localhost',
       'username' => 'root',
       'password' => '',
       'database' => 'gst_notes',
       'charset' => 'utf8mb4'
   ];
   ```

### 3. Web Server Setup

1. Copy all files to your web server directory (e.g., `htdocs`, `www`)
2. Ensure PHP mysqli extension is enabled
3. Access via browser: `http://localhost/GST_Notes/`

## File Structure

```
GST_Notes/
├── index.php              # Main application file with sidebar
├── config.php             # Database configuration and helper functions
├── database.sql           # Database schema and sample data
├── pages/
│   ├── dashboard.php       # Dashboard with statistics
│   ├── credit_notes.php    # Credit notes CRUD operations
│   └── debit_notes.php     # Debit notes CRUD operations
└── README.md              # This file
```

## Usage

### Dashboard
- View summary statistics for credit and debit notes
- See recent transactions
- Quick navigation to different sections

### Adding Notes
1. Click "Add New" from sidebar or list view
2. Fill in all required fields (marked with *)
3. Enter taxable amount and GST rates
4. GST amounts and total are calculated automatically
5. Click "Save" to create the note

### Viewing Notes
- List view shows all notes with search functionality
- Click "View" to see detailed information
- Click "Edit" to modify existing notes
- Click "Delete" to remove notes (with confirmation)

### Search
- Search across note numbers, party names, or invoice numbers
- Results update in real-time

## GST Calculation

The system automatically calculates:
- CGST Amount = (Taxable Amount × CGST Rate) / 100
- SGST Amount = (Taxable Amount × SGST Rate) / 100
- IGST Amount = (Taxable Amount × IGST Rate) / 100
- Total Amount = Taxable Amount + CGST + SGST + IGST

## Sample Data

The system comes with sample data:
- 2 Credit Notes (1 sales, 1 purchase)
- 2 Debit Notes (1 sales, 1 purchase)

## Note Number Format

Auto-generated format:
- Credit Notes: `CN-YYYY-001`, `CN-YYYY-002`, etc.
- Debit Notes: `DN-YYYY-001`, `DN-YYYY-002`, etc.

Where YYYY is the current year.

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- mysqli PHP extension

## Browser Support

- Chrome (recommended)
- Firefox
- Safari
- Edge

## Customization

### Colors and Styling
Modify the CSS in `index.php` to change colors, fonts, or layout.

### Fields
Add new fields by:
1. Updating database schema
2. Modifying the forms in credit_notes.php and debit_notes.php
3. Updating the INSERT/UPDATE queries

### Note Number Format
Change the `generateNoteNumber()` function in `config.php`.

## Security Notes

- No authentication required (as requested)
- Uses prepared statements to prevent SQL injection
- Input sanitization with htmlspecialchars()
- CSRF protection not implemented (add if needed for production)

## Troubleshooting

### Database Connection Error
- Check database credentials in `config.php`
- Ensure MySQL server is running
- Verify database exists

### Permission Issues
- Ensure web server has read access to files
- Check file permissions (644 for files, 755 for directories)

### Calculation Not Working
- Ensure JavaScript is enabled in browser
- Check browser console for errors

## Support

For issues or enhancements:
1. Check the database connection first
2. Verify all required fields are filled
3. Check browser console for JavaScript errors
4. Ensure PHP error reporting is enabled for debugging

## Version

Version 1.0 - Initial release with full CRUD functionality for GST Credit and Debit Notes.
